﻿using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Linq;

namespace Framework.Web.UI
{
    /// <summary>
    /// 複合必須（どれかが入力されたら他も必須になる）の検証コントロール
    /// </summary>
    [DefaultProperty("ControlToValidate")]
    [ToolboxData("<{0}:CompositeRequiredValidator runat=server></{0}:CompositeRequiredValidator>")]
    public class CompositeRequiredValidator : WebControl, IInputControl
    {
        /// <summary>
        /// 対象のコントロールを','でつないで登録する。
        /// </summary>
        [Category("Custom")]
        [DefaultValue("")]
        public string ControlsToValidate { get; set; }


        #region IInputControl メンバ

        public bool IsValid
        {
            get { return true; }
            set { }
        }

        public System.Web.UI.Control GetErrorControl()
        {
            return this;
        }

        public bool IsInputed()
        {
            return false;
        }

        public bool IsBlank()
        {
            return false;
        }

        public bool ValidateInput(bool dataTypeOnly)
        {
            if (dataTypeOnly == true) return true;

            if (string.IsNullOrEmpty(this.ControlsToValidate))
            {
                return true;
            }

            bool inputed = false;
            var ctrls = this.ControlsToValidate.SplitByConma().Select(t=>t.Trim()).ToArray();
            var inputControls = new IInputControl[ctrls.Length];

            //対象のコントロールの中に値が入力されているものがあるか？
            for (int i = 0; i < ctrls.Length; i++)
            {
                inputControls[i] = (IInputControl)this.NamingContainer.FindControl(ctrls[i]);

                if (inputControls[i].IsInputed())
                {
                    inputed = true;
                }
            }

            if (!inputed)
            {
                return true;
            }

            //全部未入力だったらエラーにしない。
            //MTextBoxやMDropDownListなどDefaultValue属性があるコントロールの場合、
            //入力されていても（DefaultValueと違う）空というケースがあるため、このような処理を追加（3/15 suda)
            bool isBlankAll = true;
            foreach (IInputControl ic in inputControls)
            {
                if (ic.IsBlank() == false)
                {
                    isBlankAll = false;
                    break;
                }
            }
            if (isBlankAll)
            {
                return true;
            }

            //対象のコントロールの中に未入力のものがあった場合にはエラーにする
            bool ret = true;
            foreach (IInputControl ic in inputControls)
            {
                if (ic.IsBlank())
                {
                    ret = false;
                    ic.SetValidateResult(false);
                }
                else
                {
                    ic.SetValidateResult(true);
                }
            }

            return ret;
        }

        public void SetValidateResult(bool isSuccess)
        {
            //何もしない
        }

        public void ClearInput()
        {
            //何もしない
        }

        public string GetInputValue()
        {
            return null;
        }
 
        #endregion
    }
}
